<?php
function readCSV($defaultFilename = 'links.csv') {
    $domain = $_SERVER['HTTP_HOST'];
    $domainsFile = __DIR__ . '/../data/domains.txt';
    $csvFilename = $defaultFilename;

    if (file_exists($domainsFile)) {
        $lines = file($domainsFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
            [$domainCheck, $csvFile] = array_map('trim', explode(';', $line));
            if (strcasecmp($domain, $domainCheck) === 0 && file_exists('data/' . $csvFile)) {
                $csvFilename = 'data/' . $csvFile;
                break;
            }
        }
    }

    $rows = array_map('str_getcsv', file($csvFilename));
    $header = array_shift($rows);
    $csv = [];

    // Загрузка данных из файлов pref.txt и post.txt
    $prefList = file_exists('data/pref.txt') ? file('data/pref.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
    $postList = file_exists('data/post.txt') ? file('data/post.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];

    foreach ($rows as $row) {
        $assoc = array_combine($header, $row);

        foreach ($assoc as $key => $value) {
            if (strpos($value, '[pref]') !== false && !empty($prefList)) {
                $assoc[$key] = str_replace('[pref]', $prefList[array_rand($prefList)], $value);
            }

            if (strpos($value, '[post]') !== false && !empty($postList)) {
                $assoc[$key] = str_replace('[post]', $postList[array_rand($postList)], $assoc[$key]);
            }
        }

        $csv[] = $assoc;
    }

    return $csv;
}
